<?php

namespace UtillzCore\Inc\Src\Submission\Modules\Success;

use \UtillzCore\Inc\Src\Submission\Modules\Module;

class Success extends Module {

    public function controller() {

        global $ulz_submission;

        return [
            'requires_admin_approval' => $ulz_submission->listing_type->get('ulz_requires_admin_approval'),
            'strings' => (object) [
                'success' => esc_html__('Your submission was successful!', 'utillz-core'),
                'awaits_approval' => esc_html__('Your submission has been sent and awaits approval', 'utillz-core'),
                'published' => esc_html__('Your submission has been sent and published', 'utillz-core'),
            ]
        ];

    }

    public function validation() {

        return wp_send_json([
            'success' => true
        ]);

    }

}
